{$x+}
{$IFDEF VER90}
{$H-}
{$ENDIF}
{ Useisam.Pas   Rev 01.0 vom  9. Juni   89: Isam 3.0 , Turbo 4.0
                Rev 02.0 vom 24. April  91: Isam 5.21, Turbo 6.0
                Rev 03.0 vom 26. Mai    92: Isam 5.3 , Turbo 6.0
                Rev 04.0 vom  3. Januar 93: Isam 5.4 , BP 7.0
                Rev 05.0 vom 22. August 95: Filer 5.5, Delphi
                Rev 06.0 vom 30. Mrz   96: Filer 5.52,Delphi
                Rev 07.0 vom  9. April  96: Filer 5.52,Delphi20 32bit
                Rev 07.1 vom 27. September: kleinere nderungen ohne Bedeutung

  Inhalt: Routinen zur Untersttzung der Netisam
}
unit Uuseisam;


interface


USES Filer, UToolDll, isamtool;


procedure DIEE;
Procedure DIE;
function  IA:boolean; {Testet, ob Dialog-Meldung vorliegt und lscht sie}
function NotFound:boolean; {Testet, ob bei letzter Op. "nicht gef." herauskam}

const Isamwsnr : Longint = 1;
      MySAVE   : Boolean = FALSE;

      FindFirst  = 0;
      FindLast   = 1;
      FindNext   = 2;
      FindPrev   = 3;
      FindALL    = 4;

var
  SatzNoAngel : longint;
  IsamFehler  : Integer Absolute IsamError;
  InitCount   : Integer;




type
  KeyProc    = Function ( Var DSatz; KeyNr : Word ) : IsamKeyStr;
  ChangeProc = Function(var DatOld,DatNew;Len:word):boolean;


Function EXISTIsam(IfbPtr:IsamFileBlockPtr;Name:STring):Boolean;
PROCEDURE EXITIsam;
Function INITIsam(Netz:NetSupportType) : Boolean;


PROCEDURE CLEARKEY(VAR IFBPtr : ISAMFILEBLOCKPTR;KEY: INTEGER);
{Setzt den Datensatzzeiger auf den 1. Schlssel von Key

  IFBPtr  : Dateivariable
  Key     : Keynummer
}

PROCEDURE READLOCK(VAR IFBPtr : ISAMFILEBLOCKPTR);
{Setzt ein READLOCK auf die Datei

  IFBPtr  : Dateivariable
}
PROCEDURE LOCK(VAR IFBPtr : ISAMFILEBLOCKPTR);
{Setzt ein LOCK auf die Datei

  IFBPtr  : Dateivariable
}
PROCEDURE UNLOCK(VAR IFBPtr : ISAMFILEBLOCKPTR);
{Hebt den READLOCK auf

  IFBPtr  : Dateivariable
}


procedure SatzLesen (Var IFBPtr : IsamFileBlockPtr;RefNr:longint;
                     var Ziel,Dup);
{Liest einen Satz aus der angegebenen Isam-Datei.

  IFBPtr  : Dateivariable
  RefNr   : Datensatznummer des zu lesenden Satzes
  Ziel    : Variable, in der der Satz gespeichert werden soll
  Dup     : mu vom selben Typ wie Ziel sein. Wird von den Schreibprozeduren
            verwendet, um festzustellen, ob der Satz inzwischen verndert
            wurde. Darf daher nicht von Hand verndert werden.

  Bitte anschlieend IsamOK beachten.
  Fehlermglichkeiten: wie bei GetNetRec.
}

procedure SatzAendern(Var IFBPtr:IsamFileBlockPtr;RefNr:longint;
                      Var Quelle,Dup;Keys:KeyProc;var OK:boolean);
{Schreibt einen genderten Satz zurck in die Isam-Datei.

  IFBPtr  : Dateivariable
  RefNr   : Datensatznummer des zurckzuschreibenden Satzes
  Quelle  : zu schreibender Satz
  Dup     : mu das von SatzLesen erzeugte Duplikat des alten Satzes enthalten
  Keys    : Zeiger auf eine Funktion, die die Datensatzschlssel ermittelt.
            (s. Anmerkungen zu "type KeyProc" weiter oben.)
  OK      : enthlt OK nach der Ausfhrung FALSE, so konnte nicht geschrieben
            werden, weil der Satz inzwischen verndert wurde oder weil das n-
            dern einen doppelten Hauptschlssel zur Folge htte.

  Bitte anschlieend IsamOk und OK beachten.
  Fehlermglichkeiten: wie bei LockFileBlock, GetNetRec, PutNetRec,
  DeleteKey, AddKey, UnlockFile sowie siehe OK.

}

procedure SatzAnlegen(Var IFBPtr:IsamFileBlockPtr;
                     var Quelle;Keys:KeyProc);
{Legt einen Satz an.

  IFBPtr  : Dateivariable
  Quelle  : zu schreibender Satz
  Keys    : s. SatzAendern, type KeyProc

  Bitte anschlieend IsamOK beachten.
  Fehlermglichkeiten: wie bei LockFileBlock, AddNetRec, AddKey,
  UnlockFile.

}


procedure Satzloeschen(Var IFBPtr:IsamFileBlockPtr;RefNr:longint;
                       var Dup;Keys:KeyProc;var OK:boolean);
{Lscht einen Satz.

  IFBPtr  : Dateivariable
  RefNr   : Nummer des zu lschenden Satzes
  Dup     : s. SatzAendern
  Keys    : s. SatzAendern, type KeyProc
  OK      : s. SatzAendern

  Bitte anschlieend IsamOk beachten.
  Fehlermglichkeiten: s. SatzAendern
}

procedure DateiOeffnen (var IFBPtr:IsamFileBlockPtr;Name:String;Save:boolean;
          RSize:longint);
{ffnet einen Fileblock.

  IFBPtr  : Dateivariable
  Name    : Pfad+Vorname der Datei
  Save    : TRUE, wenn im Savemodus geffnet werden soll
  RSize   : Datensatzrecordgre. Dient der Kontrolle, ob Programm- und
            Dateiversion kompatibel sind.

  Bitte anschlieend IsamOk beachten.
  Fehlermglichkeiten wie Open(Save)NetFileBlock.
}

procedure DateiSchliessen (var IFBPtr:IsamFileBlockPtr);
{Schliet einen Fileblock.

  IFBPtr  : Dateivariable

  Bitte anschlieend IsamOk beachten.
  Fehlermglichkeiten wie bei CloseNetFileBlock.
}

procedure KeySuchen (var IFBPtr:IsamFileBlockPtr;Key:integer;
                     var Userdatref:Longint;var Userkey:IsamKeyStr;
                     var Found:boolean);
{Sucht einen Schlssel.

  IFBPtr  : Dateivariable
  Key     : Schlsselnummer
  UserdatRef : erhlt die Datensatznummer des gefundenen Schlssels
  UserKey : zu suchender Schlssel
  Found   : TRUE:  gewnschter Schlssel wurde gefunden.
            FALSE: gewnschter Schlssel wurde nicht gefunden, weil
              IsamOK=TRUE:  er nicht existiert. Userkey enthlt den nchsten
                            greren Schlssel.
              IsamOK=FALSE: der Zugriff wegen eines Fehlers nicht durchge-
                            fhrt werden konnte.

  Bitte anschlieend IsamOk beachten.
  Fehlermglichkeiten wie bei SearchKey.
}

procedure RefSuchen (var IFBPtr:IsamFileBlockPtr;Key:integer;
                     var Userdatref:Longint;var Userkey:IsamKeyStr;
                     var Found:boolean);
{Sucht einen Schlssel mit Referenz.

  IFBPtr  : Dateivariable
  Key     : Schlsselnummer
  UserdatRef : Datensatznummer des zu suchenden Schlssels
  UserKey : zu suchender Schlssel
  Found   : TRUE:  gewnschter Schlssel wurde gefunden.
            FALSE: gewnschter Schlssel wurde nicht gefunden, weil
              IsamOK=TRUE:  er nicht existiert. Userkey enthlt den nchsten
                            greren Schlssel.
              IsamOK=FALSE: der Zugriff wegen eines Fehlers nicht durchge-
                            fhrt werden konnte.

  Bitte anschlieend IsamOk beachten.
}

procedure SatzEinlesen(var IFBPtr:IsamFileBlockPtr;Key:integer;
                       var Satz,Dup;Keys:KeyProc;var Klar:boolean);
{Liest einen Satz ein. Funktionsweise: Die Felder der Variablen "Satz", die
 bekannt sind, mssen vor Aufruf besetzt werden (z.B. das Kundennummernfeld,
 wenn nach einer Kundennummer gesucht werden soll). Diese Prozedur sucht
 dann den passenden Satz und liest ihn ein.

   IFBPtr  : Dateivariable
   Key     : Nummer das Schlssels, anhanddessen gesucht werden soll
   Satz    : s.o., erhlt hinterher den kompletten Satz
   Dup     : s. SatzLesen
   Keys    : s. SatzAendern, type KeyProc
   Klar    : TRUE, wenn der Satz gefunden und ordnungsgem gelesen wurde

   Bitte anschlieend IsamOk beachten.
   Fehlermglichkeiten wie bei SearchKey, GetNetRec.
 }



procedure NachbarKey(var IFBPtr:IsamFileBlockPtr;Key:integer;
                     var UserDatRef:longint;var UserKey:IsamKeyStr;
                     SuchArt:byte);
{Sucht den nchsten bzw. vorigen Schlssel.

  IFBPtr  : Dateivariable
  Key     : Schlsselnummer
  UserDatRef : erhlt die Datensatznummer des gefundenen Schlssels
  UserKey : erhlt den gefundenen Schlssel
  SuchArt : 0=der erste Schlssel wird gesucht
            1=der letzte Schlssel wird gesucht
            2=der nchste Schlssel wird gesucht
            3=der vorige   Schlssel wird gesucht
            4=der erste bereinstimmende Schlssel (FINDKEY) wird gesucht

  Bitte anschlieend IsamOk beachten.
  Fehlermglichkeiten wie bei NextKey, PrevKey, ClearKey.
}


procedure DeleteAllRecs(var IFBPtr    : IsamFileBlockPtr;
                            VonKey,
                            BisKey    : IsamKeyStr;
                            Key       : integer;
                            Keys      : KeyProc);

{Lscht alle Datenstze, die im angegebenen Bereich von Schlsseln liegen.

    IFBPtr  :  bezogener FileBlock
    VonKey  :  kleinster Schlssel, der gelscht werden soll
    BisKey  :  kleinster Schlssel, der nicht mehr gelscht werden soll
               (also obere Grenze, bleibt selbst aber erhalten)
    Key     :  Schlsselnummer.
}
procedure LockFile(Var IFBPtr:IsamFileBlockPtr);
procedure UnlockFile(var IFBPtr:IsamFileBlockPtr);
{Achtung: Vor KeysAendern LOCKFILE!!!}
procedure KeysAendern(var IFBPtr:IsamFileBlockPtr;var Quelle,Dup;
          RefNr:longint;Keys:KeyProc;var OK:boolean);

const ErrorFile:String = '';

var
  NetInUse   : boolean;

type
  PrPrTyp   = procedure (s:String);

var
  PrPr  : PrPrTyp;

const
  IsamAntwort : word = 0;

implementation

var
  RepCnt  : byte;

const
  LastFB  : IsamFileBlockPtr = nil;
  FlushDelay : longint = 900; {Sek.}

const
  DelTime     = 100;
  NrOfReps    : byte = 3;

Function GetMess(Id: Integer): String;
var S: String;
begin
  if Sprache = 1 then begin
    Case Id of
       1: S:= 'Record is locked, cant read.';
       2: S:= 'Repeat ?';
       3: S:= 'File was opened in SAVE-Mode';
       4: S:= 'Can`t open, file is locked';
       5: S:= 'File couldnt be closed because of filelock';
       6: S:= 'Press ENTER to try again.';
       7: S:= 'Can`t write, file is locked';
       8: S:= 'Lock error ';
       9: S:= 'Can`t unlock, file is locked by other user.';
      10: S:= 'BTDELETEKEY-Error: ';
      11: S:= 'BTADDKEY-Error: ';
      12: S:= 'LOCKIT-Error: ';
      13: S:= 'RECSIZE-Error: ';
      14: S:= '';
      15: S:= 'GETREC-Error: ';
      16: S:= 'Record change:';
      17: S:= 'keys couldnt be changed correctly !';
      18: S:= 'BTPUTREC-Error ';
      19: S:= 'Record change:';
      20: S:= 'Record was changed in the meantime';
      21: S:= 'Attention! IsamError ';
      22: S:= 'Cant search, file is locked.';
      23: S:= 'Cant skip, file is locked.';
      24: S:= 'reached end of file';
      25: S:= 'IsamError-Message ';
      26: S:= '';
      27: S:= 'CLEARKEY-Error, file is locked.';
      28: S:= 'Cant READLOCK, file is locked by other user.';
      29: S:= 'Cant LOCK, file is locked by other user.';
      30: S:= 'Cant READUNLOCK, file is locked by other user.';
      31: S:= 'That is impossible: InitCount = ';
      else S:= '';
    end;
  end
  else begin
    Case Id of
       1: S:= 'Lesen z.Zt. nicht mglich wegen Locking';
       2: S:= 'Wiederholen ?';
       3: S:= 'Datei wurde im SAVEMODUS geffnet';
       4: S:= 'Zugriff z.Zt. nicht mglich wegne Locking';
       5: S:= 'Datei konnte nicht geschlossen werden wegen Locking.';
       6: S:= 'Bitte <RETURN> fr einen neuen Versuch.' ;
       7: S:= 'Schreiben z.Zt. nicht mglich wegen Locking.';
       8: S:= 'LockFehler ';
       9: S:= 'UNLOCK z.Zt. nicht mglich wegen Locking.';
      10: S:= 'FEHLER BEI BTDELETEKEY: ';
      11: S:= 'FEHLER BEI BTADDKEY: ';
      12: S:= 'FEHLER BEI LOCKIT: ';
      13: S:= 'FEHLER BEI RECSIZE: ';
      14: S:= '';
      15: S:= 'FEHLER BEI GETREC: ';
      16: S:= 'Satzndern:';
      17: S:= 'Keys konnten nicht korrekt gendert werden!!';
      18: S:= 'Fehler bei BTPUTREC ';
      19: S:= 'Satzndern:';
      20: S:= 'Satz wurde zwischenzeitlich von jemand gendert.';
      21: S:= 'Achtung! IsamFehler ';
      22: S:= 'Suche z.Zt nicht mglich wegen Locking.';
      23: S:= 'Blttern z.Zt nicht mglich wegen Locking.';
      24: S:= 'Dateiende erreicht';
      25: S:= 'IsamAntwort Meldung';
      26: S:= '';
      27: S:= 'CLEARKEY z.Zt nicht mglich wegen Locking.';
      28: S:= 'READLOCK z.Zt nicht mglich wegen Locking.';
      29: S:= 'LOCK z.Zt nicht mglich wegen Locking.';
      30: S:= 'READUNLOCK z.Zt nicht mglich wegen Locking.';
      31: S:= 'Das kann nicht sein: InitCount =';
      else S:= '';
    end;
  end;
  Result:= S;
end;

function Compare(var A,B;Count:word):boolean;
{$IFDEF VER90}
begin
  Result:= True;
end;
{$ELSE}
inline
($59/      {POP CX    (count)}
 $8C/$DA/  {MOV DX,DS (Inhalt sichern)}
 $5E/      {POP SI}
 $1F/      {POP DS    (B)}
 $5F/      {POP DI}
 $07/      {POP ES}
 $FC/      {CLD}
 $B8/$00/$00/{MOV AX,0000}
 $F3/$A6/  {REPZ CMPSB}
 $75/$03/  {JNZ x}
 $B8/$01/$00/{MOV AX,0001}
 $8E/$DA   {x:MOV DS,DX}
);
{$ENDIF}


Procedure Delay(t: Integer);
begin
end;

procedure SatzLesen;

  label a;

  var
    t   : char;

  begin
    LastFB := IFBPtr;
a:  RepCnt := NrOfReps;
    repeat
      dec(RepCnt);
      BTGetRec(IFBPtr,RefNr,Ziel,false);
      IF NOT ISAMOK AND (DELTIME <> 0) THEN DELAY(DELTIME);
    until (BTIsamErrorClass<>2) or (RepCnt=0);
    if BTIsamErrorClass=2 then begin
      if JaNein(GetMess(1),GetMess(2))
      then goto a;
    end;
    if IsamOk then move(Ziel,Dup,BTDatRecordSize(IFBPtr));
  end;

procedure DateiOeffnen;

  label a;

  var
    t   : char;
    t2  : byte;

  begin

a:  RepCnt := NrOfReps;
    repeat
      if RepCnt <> NrOfReps then  waitwindow(intstr(NrOfReps-RepCnt+1)
                                  +'. Versuch Dateiffnen'
                                  +#13+'          von '
                                  +Dezstr(NrOfReps)+' Versuchen','wegen Locking');
      dec(RepCnt);
      if MySave then Serrorwindow(GetMess(3),'');
      BTOpenFileBlock(IFBPtr,Name,false,false,MySave,true);
    until (BTIsamErrorClass<>2) or (RepCnt=0);
    CloseWait;
    if BTIsamErrorClass=2 then
    begin
      if JaNein(GetMess(4),GetMess(2))
      then goto a;
    end;
    if IsamOk then
    begin
      for t2 := 1 to IFBPtr^.NrOfKeys do BTSetSearchForSequential(IFBPtr,t2,true);
      if BTDatRecordSize(IFBPtr)<>RSize then
      begin
        isamfehler := 24;
        IsamOk := False;
      end;
      LastFB := IFBPtr;
    end else begin
      LastFB := nil;
      ErrorFile := Name;
      IsamOk := False;
      IsamFehler := IsamError;
    end;
  end;


procedure DateiSchliessen;

  label a;

  begin
    LastFB := IFBPtr;
a:  RepCnt := NrOfReps;
    repeat
      dec(RepCnt);
      BTCloseFileBlock(IFBPtr);
      IF NOT ISAMOK AND (DELTIME <> 0) THEN DELAY(DELTIME);
    until (BTIsamErrorClass<>2) or (RepCnt=0);
    if BTIsamErrorClass=2 then begin
      ErrorWindow(GetMess(5)+  ZeroStrToStr(LastFB^.DatF.Name),GetMess(6));
      goto a;
    end;
  end;


procedure LockFile;

  label a;

  var
    t : char;

  begin
    LastFB := IFBPtr;
    ISAMCLEAROK;
a:  RepCnt := NrOfReps;
    repeat
      dec(RepCnt);
      BTLockFileBlock(IFBPtr);
      IF NOT ISAMOK AND (DELTIME <> 0) THEN DELAY(DELTIME);
    until (BTIsamErrorCLASS<>2) or (RepCnt=0);
    if (BTIsamErrorClass=2) OR NOT ISAMOK then begin
      if JaNein(GetMess(7),GetMess(2))
      then goto a;
    end;
    IF BTIsamErrorClass <> 0 THEN ERRORWINDOW(GetMess(8),DEZSTR(ISAMERROR));
  end;

procedure UNLockFile;

  label a;

  var
    t : char;

  begin
    LastFB := IFBPtr;
    ISAMCLEAROK;
a:  RepCnt := NrOfReps;
    repeat
      dec(RepCnt);
      BTUNLockFileBlock(IFBPtr);
    until (BTIsamErrorCLASS<>2) or (RepCnt=0);
    if (BTIsamErrorClass=2) OR NOT ISAMOK then begin
      if JaNein(GetMess(9),GetMess(2))
      then goto a;
    end;
    IF BTIsamErrorClass <> 0 THEN ERRORWINDOW(GetMess(8),DEZSTR(ISAMERROR));
  end;


type
  tLockArt = (LANoLock,LARdLock,LALock);

procedure LockIt(var IFBPtr:IsamFileBlockPtr;var LStore:tLockArt);
  begin
    if BTFileBlockIsReadLocked(IFBPtr) then begin
      LStore := LARdLock;
    end else if BTFileBlockIsLocked    (IFBPtr) then begin
      LStore := LALock
    end else LStore := LANoLock;
    LockFile(IFBPtr);
  end;

procedure UnlockIt(var IFBPtr:IsamFileBlockPtr;LStore:tLockArt);

  begin
    UnlockFile(IFBPtr);
  end;

procedure KeysAendern;

  var
    ks1,
    ks2     : String;
    FehlNo,
    KeyCnt  : word;
    Status  : boolean;
  Label FEHLER0,FEHLER1,FEHLER2,FEHLER3,FEHLER4;

  begin
    LastFB := IFBPtr;
    KeyCnt := 1;
    ISAMCLEAROK;
    while (KeyCnt<=IFBPtr^.NrOfKeys) and IsamOk do
    begin
      Ks1 := KEYS(Quelle,KeyCnt);
      Ks2 := KEYS(DUP,KeyCnt);
      Status := false;
      if ks1<>Ks2 then begin
   FEHLER0:
        ISAMCLEAROK;
        BTDeleteKey(IFBPtr,KeyCnt,RefNr,ks2);
        IF NOT ISAMOK THEN IF JANEIN(GetMess(10)+ INTSTR(ISAMERROR),GetMess(2)) THEN GOTO FEHLER0;
        if IsamOk then
        begin
          Status := true;
   FEHLER1:
          ISAMCLEAROK;
          BTAddKey(IFBPtr,KeyCnt,RefNr,ks1);
          IF NOT ISAMOK THEN IF JANEIN(GetMess(11)+ INTSTR(ISAMERROR),GetMess(2)) THEN GOTO FEHLER1;
        end;
      end;
      if IsamOk then inc(KeyCnt);
    end;


    OK := IsamOk;
    if not IsamOk then
    begin
      FehlNo := IsamError;
      if Status then
      BEGIN
   FEHLER2:
        ISAMCLEAROK;
        BTAddKey(IFBPtr,KeyCnt,RefNr,ks2);
        IF NOT ISAMOK THEN IF JANEIN(GetMess(11)+'2'+ INTSTR(ISAMERROR),GetMess(2)) THEN GOTO FEHLER2;
      END;
      for KeyCnt := 1 to KeyCnt-1 do begin
        Ks1 := KEYS(Quelle,KeyCnt);
        Ks2 := KEYS(DUP,KeyCnt);
        Status := false;
        if ks1<>Ks2 then
        begin
            ISAMCLEAROK;
   FEHLER3:
            BTDeleteKey(IFBPtr,KeyCnt,RefNr,ks1);
            IF NOT ISAMOK THEN IF JANEIN(GetMess(10)+'2'+ INTSTR(ISAMERROR),GetMess(2)) THEN GOTO FEHLER3;
   FEHLER4:
            ISAMCLEAROK;
            BTAddKey(IFBPtr,KeyCnt,RefNr,ks2);
            IF NOT ISAMOK THEN IF JANEIN(GetMess(11)+'3'+ INTSTR(ISAMERROR),GetMess(2)) THEN GOTO FEHLER4;
        end;
      end;
      if IsamOk then IsamError := FehlNo;
      if IsamError=10230 then
      begin {Schlssel doppelt}
        IsamError := 0;
        IsamOk     := true;
      end else IsamOk := false;
    end;
  end;

procedure SatzAendern;

  label
    Hilfe;

  var
    tds        : pointer;
    rs         : longint;
    KeyCnt     : word;
    WarLocked  : tLockArt;
    LABEL FEHLER0,FEHLER1,FEHLER2,FEHLER3,FEHLER4;

  begin
    OK := false;

  FEHLER0:
    ISAMCLEAROK;
    LockIt(IFBPtr,WarLocked);
    IF NOT ISAMOK THEN IF JANEIN(GetMess(12)+ INTSTR(ISAMERROR),GetMess(2)) THEN GOTO FEHLER0;
    if IsamOk then
    begin
  FEHLER1:
      ISAMCLEAROK;
      rs := BTDatRecordSize(IFBPtr);
      IF NOT ISAMOK THEN IF JANEIN(GetMess(13)+ INTSTR(ISAMERROR),'RS: '+DEZSTR(RS)+GetMess(2)) THEN GOTO FEHLER1;
      getmem(tds,rs);
  FEHLER2:
      ISAMCLEAROK;
      BTGetRec (IFBPtr,RefNr,tds^,TRUE);
      IF NOT ISAMOK THEN IF JANEIN(GetMess(15)+INTSTR(ISAMERROR),'REF: '+DEZSTR(REFNR)+GetMess(2)) THEN GOTO FEHLER2;
      if not IsamOk then goto Hilfe;
      if compare (tds^,Dup,rs) then
      begin
        KeysAendern(IFBPtr,Quelle,Dup,RefNr,Keys,OK);
        if not OK then errorwindow ('Satzndern:',
        'Keys konnten nicht korrekt gendert werden!!');
        OK := true;
  FEHLER3:
        ISAMCLEAROK;
        BTPutRec(IFBPtr,RefNr,Quelle,false);
        IF NOT ISAMOK THEN IF JANEIN(GetMess(18)+ DEZSTR(ISAMERROR),'REF: '+DEZSTR(REFNR)+GetMess(2)) THEN GOTO FEHLER3;
      end else errorwindow(GetMess(19),GetMess(20));
  Hilfe:
      IF NOT ISAMOK THEN  ERRORWINDOW('WSNR  : ',
                                      'ERROR: '+INTSTR(IsamError));
      KeyCnt := IsamError;
      freemem(tds,rs);
  FEHLER4:
      ISAMCLEAROK;
      UnlockIt(IFBPtr,WarLocked);
      IF NOT ISAMOK THEN IF JANEIN(GetMess(12)+ INTSTR(ISAMERROR),'REF: '+DEZSTR(REFNR)+GetMess(2)) THEN GOTO FEHLER4;
      if IsamOk then
      begin
        IsamOk := KeyCnt =0;
        IsamError := KeyCnt;
      end;
      IF ISAMERROR = 10070 THEN ERRORWINDOW('?????','');
    end;
  end;



procedure SatzAnlegen;

  var
    StIF,
    KeyCnt    : word;
    RefNr     : longint;
    WarLocked : tLockArt;
    schluessel: isamkeySTR;

  begin
    LockIt(IFBPtr,WarLocked);
    if IsamOk then
    begin
      BTAddRec(IFBPtr,RefNr,Quelle);
      SatzNoAngel := RefNr;
      if IsamOk then
      begin
        KeyCnt := 1;
        while (KeyCnt<=IFBPtr^.NrOfKeys) and IsamOk do
        begin
           BTAddKey(IFBPtr,KeyCnt,RefNr,KEYS(Quelle,KeyCnt));
           inc(KeyCnt);
        end;
        if not IsamOk then
        begin
          StIF := IsamError;
          dec(keycnt);
          while keycnt > 1 do
          begin
            dec(keycnt);
            BTDELETEKEY(IFBptr,keycnt,refnr,keys(quelle,keycnt));
          end;

          BTDeleteRec(IFBPtr,Refnr);
          IsamError := StIF;
          IsamOK := false;
        end;
      end;
      KeyCnt := IsamError;
      UnlockIt(IFBPtr,WarLocked);
      if IsamOk then
      begin
        IsamOk := KeyCnt =0;
        IsamError := KeyCnt;
      end;
    end;
  end;



procedure Satzloeschen;
label hilfe;

  var
    tds       : pointer;
    rs        : longint;
    KeyCnt    : word;
    WarLocked : tLockArt;

  begin
    OK := false;
    LockIt(IFBPtr,WarLocked);
    if IsamOk then begin
      rs := BTDatRecordSize(IFBPtr);
      getmem(tds,rs);
      BTGetRec (IFBPtr,RefNr,tds^,false);
      if not IsamOk then goto Hilfe;
      if compare (tds^,Dup,rs) then begin
        for KeyCnt := 1 to IFBPtr^.NrOfKeys do begin
          BTDeleteKey(IFBPtr,KeyCnt,RefNr,Keys(Dup,KeyCnt));
        end;
        BTDeleteRec(IFBPtr,RefNr);
        OK := true;
      end;
Hilfe:
      KeyCnt := IsamError;
      freemem(tds,rs);
      UnlockIt(IFBPtr,WarLocked);
      if IsamOk then begin
        IsamOk := KeyCnt =0;
        IsamError := KeyCnt;
      end;
    end;
  end;

procedure KeySuchen;

  label a;

  var
    t   : char;
    tk  : IsamKeyStr;

  begin
    LastFB := IFBPtr;
a:  RepCnt := NrOfReps;
    tk := UserKey;
    repeat
      dec(RepCnt);
      BTSearchKey(IFBPtr,Key,UserDatRef,tk);
      IF NOT ISAMOK AND (DELTIME <> 0) THEN DELAY(DELTIME);
    until (BTIsamErrorClass<>2) or (RepCnt=0);
    if BTIsamErrorClass=2 then begin
      if JaNein(GetMess(22),GetMess(2))
      then goto a;
    end;
    if IsamOk then Found := UserKey=tk else Found := false;
    UserKey := tk;
  end;

procedure RefSuchen;

  label a;

  var
    t   : char;
    tk  : IsamKeyStr;
    tr  : longint;

  begin
    LastFB := IFBPtr;
a:  RepCnt := NrOfReps;
    tk := UserKey;
    tr := UserDatRef;
    repeat
      dec(RepCnt);
      BTFindKeyAndRef(IFBPtr,Key,tr,tk,+1);
      IF NOT ISAMOK AND (DELTIME <> 0) THEN DELAY(DELTIME);
    until (BTIsamErrorClass<>2) or (RepCnt=0);
    if BTIsamErrorClass=2 then begin
      if JaNein(GetMess(22),GetMess(2))
      then goto a;
    end;
    if IsamOk then Found := (UserKey=tk) and (UserDatRef=tr) else Found := false;
    UserKey := tk;
    UserDatRef := tr;
  end;

procedure SatzEinlesen;

  var
    Ref : longint;
    x   : IsamKeyStr;

  begin
    LastFB := IFBPtr;
    x := Keys(Satz,KEY);
    KeySuchen(IFBPtr,Key,Ref,x,Klar);
    if Klar then SatzLesen (IFBPtr,Ref,Satz,Dup);
    klar := Klar and IsamOK;
  end;

procedure NachbarKey;

  label a;

  var
    t   : char;
    uk  : IsamKeyStr;
    FOUND:BOOLEAN;

  begin
    LastFB := IFBPtr;

a:  RepCnt := NrOfReps;
    uk := USERKEY;
    ISAMCLEAROK;
    REPEAT
      dec (RepCnt);
      if Suchart=4 then
      BEGIN
        KeySuchen(IFBPtr,Key,UserDatRef,USERKEY,FOUND);
        EXIT;
      END;
      if SuchArt<2 then BTClearKey(IFBPtr,Key) else IsamOk := true;
      if IsamOK then if odd(SuchArt)
      then BTPrevKey(IFBPtr,Key,UserDatRef,uk)
      else BTNextKey(IFBPtr,Key,UserDatRef,uk);
      IF NOT ISAMOK AND (DELTIME <> 0) THEN DELAY(DELTIME);
    UNTIL (BTISAMERRORCLASS<> 2) OR (RepCnt = 0);
    if RepCnt=0 then begin
      if JaNein(GetMess(23),GetMess(2))
      then goto a;
    end;
    if IsamOK then UserKey := uk;
  end;



function IA;

  begin
    IA := (IsamAntwort <>0);
    IsamAntwort := 0;
  end;

var Klasse : byte;
{   Codes v. IsamErrorClass:
  0 : kein Fehler;
  1 : Dialog-Meldung;
  2 : Locking-Fehler (kann nur durch eine Netz-Operation erfolgen);
  3 : Operation im Save-Modus nicht ausgefhrt;
  4 : schwerer Fehler (Abbruch empfohlen);
  99: unbekannter Fehler;}



procedure DIEE;
VAR
    DUMMY,D,Z : LONGINT;
  begin
    if IsamAntwort<>0 then
    if (Isamantwort = 10250) or (IsamAntwort = 10260)
    then SErrorWindow(GetMess(24),'') else
    if IsamAntwort<>0 then if Isamantwort <> 10210 then SErrorWindow(GetMess(25) ,IntStr(IsamAntwort));
    IsamAntwort := 0;
    if not IsamOk then begin
    case IsamError of
        9900,
        9903,
        10410 : Klasse := 4;
        else  Klasse := BTIsamErrorClass;
     end;
      case Klasse of
        3,4 :
        begin
          GetSysZeit(D,Z);
          if LastFB<>nil then ErrorFile := ZeroStrToStr(LastFB^.DatF.Name);
          ERRORWINDOW(GetMess(21)+INTSTR(IsamError)+' / WS: '{+DEZSTR(ISAMWSNR)}+
                      ' / '+ERRORFILE,'');
        end;
        1 : IsamAntwort := IsamError; {Dialog-Meldung, nicht weiter beachten}

        2 : BEGIN
              if LastFB<>nil then ErrorFile := ZeroStrToStr(LastFB^.DatF.Name);
               ErrorWindow('LOCK ERROR/'{+DEZSTR(ISAMWSNR)}+ '/'+VERSIONSTR+'/'+INTSTR(IsamError)+
              '/'+ERRORFILE,'');
              IsamAntwort := IsamError;
            END;

        0 : BEGIN
              IsamAntwort := IsamError;
            END;

      end; {of CASE}
    end;
    LastFB := nil;
  end;

Procedure die;
Begin
  DIEE;
end;


var
  GlobFuncBuildKey  : KeyProc;

function MyBuildKey(var DatS;KeyNr:Integer):IsamKeyStr;

  begin
    MyBuildKey := GlobFuncBuildKey(DatS,KeyNr);
  end;


procedure DeleteAllRecs(var IFBPtr    : IsamFileBlockPtr;
                            VonKey,
                            BisKey    : IsamKeyStr;
                            Key       : integer;
                            Keys      : KeyProc);

  var
    WarLocked  : tLockArt;
    rs         : word;
    Ref        : longint;
    fnd        : boolean;
    tds        : pointer;
    AktKey     : IsamKeyStr;

  begin
    LockIt(IFBPtr,WarLocked);
    DIEE;
    rs := BTDatRecordSize(IFBPtr);
    getmem(tds,rs);
    Ref := 0;
    AktKey := VonKey;
    KeySuchen(IFBPtr,Key,Ref,AktKey,fnd);
    DIEE;
    while (AktKey<BisKey) and not IA do begin
      SatzLesen(IFBPtr,Ref,tds^,tds^);
      DIEE;
      SatzLoeschen(IFBPtr,Ref,tds^,Keys,fnd);
      DIEE;
      KeySuchen(IFBPtr,Key,Ref,AktKey,fnd);
      DIEE;
    end;
    freemem(tds,rs);
    UnLockIt(IFBPtr,WarLocked);
  end;

function NotFound;

  begin
    NotFound := IA and (IsamError=10200);
  end;

Procedure ClearKey;
label a;
var
  t   : char;
  tk  : IsamKeyStr;
BEGIN
  LastFB := IFBPtr;
a:RepCnt := NrOfReps;
  repeat
    dec(RepCnt);
    BTCLEARKEY(IfbPtr,KEY);
    IF NOT ISAMOK AND (DELTIME <> 0) THEN DELAY(DELTIME);
  until (BTIsamErrorClass<>2) or (RepCnt=0);
  if BTIsamErrorClass=2 then
  begin
     if JaNein(GetMess(27),GetMess(2))
     then goto a;
   end;
 end;


Procedure READLOCK;
label a;
var
  t   : char;
  tk  : IsamKeyStr;
BEGIN
    LastFB := IFBPtr;
a:  RepCnt := NrOfReps;
    repeat
      dec(RepCnt);
      BTREADLOCKFILEBLOCK(IfbPtr);
      IF NOT ISAMOK AND (DELTIME <> 0) THEN DELAY(DELTIME);
    until (BTIsamErrorClass<>2) or (RepCnt=0);
    if BTIsamErrorClass=2 then begin
      if JaNein(GetMess(28),GetMess(2))
     then goto a;
    end;
  end;

Procedure LOCK;
label a;
var
  t   : char;
  tk  : IsamKeyStr;
BEGIN
    LastFB := IFBPtr;
a:  RepCnt := NrOfReps;
    repeat
      dec(RepCnt);
      BTLOCKFILEBLOCK(IfbPtr);
      IF NOT ISAMOK AND (DELTIME <> 0) THEN DELAY(DELTIME);
    until (BTIsamErrorClass<>2) or (RepCnt=0);
    if BTIsamErrorClass=2 then begin
      if JaNein(GetMess(29),GetMess(2))
     then goto a;
    end;
  end;




Procedure UNLOCK;
label a;
var
  t   : char;
  tk  : IsamKeyStr;
BEGIN
    LastFB := IFBPtr;
a:  RepCnt := NrOfReps;
    repeat
      dec(RepCnt);
      BTUNLOCKFILEBLOCK(IfbPtr);
    until (BTIsamErrorClass<>2) or (RepCnt=0);
    if (BTIsamErrorClass=2) OR NOT ISAMOK then begin
      if JaNein(GetMess(30),GetMess(2))
     then goto a;
    end;
  end;


Function INITIsam(Netz:NetSupportType) : Boolean;
Var
  b : Boolean;
BEGIN
  if InitCount < 1 then begin
    b := False;
    BTinitisam(Netz,30{Filer < 5.2 = 30000+MINIMIZEUSEOFNORMALHEAP,0});
    Diee;
    If Isamok then b := True;
    INITIsam := b;
    Inc(InitCount);
  end else Inc(InitCount);
END;


PROCEDURE EXITIsam;
BEGIN
  if InitCount < 0 then errorwindow(GetMess(31),'InitCount =' + intStr(InitCount));
  if InitCount < 2 then
  begin
    BTUNLOCKALLOPENFILEBLOCKS;
    BTCloseAllFileBlocks;
    BTExitIsam;
    Dec(InitCount);
  end else Dec(InitCount);
END;

Function EXISTIsam(IfbPtr:IsamFileBlockPtr;Name:STring):Boolean;
Var
B : Boolean;
begin
  B := True;
  BTOpenFileBlock(IFBPtr,Name,false,false,false,true);
  if Isamerror = 9903 then B := False ;
  BTCloseFileBlock(IFBPtr);
  IsamError := 0;
  Isamok := true;
  ExistIsam := B;
end;

begin
  MySave := False;
  InitCount := 0;
end.

